package jamezo97.clonecraft.Synchronize;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;

public class DataSynchronizer {
	
	Synchronizable object;
	Class theClass;
	ClassData classData;
	
	private boolean dataChanged = false;
	
	boolean isAutomatic;
	
	public DataSynchronizer(Synchronizable o, boolean isAutomatic){
		object = o;
		theClass = o.getClass();
		classData = initClass(theClass);
		
		this.isAutomatic = isAutomatic;
		
		init();
	}
	
	public void init(){
		Iterator<Entry<Integer, Field>> it = classData.getIdToFieldIterator();
		while(it.hasNext()){
			Entry<Integer, Field> entry = it.next();
			int id = entry.getKey();
			Field field = entry.getValue();
			idToValue.put(id, getFieldValue(field));
		}
	}
	
	private Object getCurrentValue(int id){
		Field f = classData.getFieldForId(id);
		if(f != null){
			return getFieldValue(f);
		}
		return null;
	}
	
	private Object getFieldValue(Field f){
		try{
			return f.get(object);
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	
	HashMap<Integer, Object> idToValue = new HashMap<Integer, Object>();
	
	ArrayList<Integer> toSync = new ArrayList<Integer>();
	
	public void synchronize(){
		if(isAutomatic){
			Iterator<Entry<Integer, Field>> it = classData.getIdToFieldIterator();
			while(it.hasNext()){
				Entry<Integer, Field> entry = it.next();
				int id = entry.getKey();
				Field field = entry.getValue();
				Object value = getFieldValue(field);
				
				Object previousValue = idToValue.get(id);
				
				if(!(value == null && previousValue == null) && (value==null?!previousValue.equals(value):!value.equals(previousValue))){
					toSync.add(id);
				}
				
				idToValue.put(id, value);
			}
			sync();
		}else{
			sync();
		}
	}
	
	private void sync(){
		if(toSync.size() > 0){
			HashMap<Integer, SyncData> data = new HashMap<Integer, SyncData>();
			
			for(int a = 0; a < toSync.size(); a++){
				int id = toSync.get(a);
				int channel = classData.getIdChannel(id);
				Object value = idToValue.get(id);
				if(!data.containsKey(channel)){
					data.put(channel, new SyncData(channel));
				}
				data.get(channel).addData(id, value);
			}
			
			SyncData[] syncDatas = new SyncData[data.size()];
			Iterator<Entry<Integer, SyncData>> dataIt = data.entrySet().iterator();
			int index = 0;
			while(dataIt.hasNext()){
				syncDatas[index++] = dataIt.next().getValue();
			}
			if(syncDatas.length > 0){
				object.sendData(syncDatas);
			}
			toSync.clear();
		}
	}
	
	SyncData[] allData = null;
	
	private void updateAllData(){
		HashMap<Integer, SyncData> data = new HashMap<Integer, SyncData>();
		
		Iterator<Entry<Integer, Object>> it = idToValue.entrySet().iterator();
		while(it.hasNext()){
			Entry<Integer, Object> entry = it.next();
			int id = entry.getKey();
			int channel = classData.getIdChannel(id);
			Object value = entry.getValue();
			if(!data.containsKey(channel)){
				data.put(channel, new SyncData(channel));
			}
			data.get(channel).addData(id, value);
		}
		
		SyncData[] syncDatas = new SyncData[data.size()];
		Iterator<Entry<Integer, SyncData>> dataIt = data.entrySet().iterator();
		int index = 0;
		while(dataIt.hasNext()){
			syncDatas[index++] = dataIt.next().getValue();
		}
		allData = syncDatas;
	}
	
	public SyncData[] getSyncDataForAllValues(){
		if(dataChanged || allData == null){
			updateAllData();
		}
		return allData;
	}
	
	public void recieveData(SyncData syncData, Object sender){
		Iterator<Entry<Integer, Object>> it = syncData.idToValue.entrySet().iterator();
		while(it.hasNext()){
			Entry<Integer, Object> entry = it.next();
			int id = entry.getKey();
			Object value = entry.getValue();
			Field field = classData.getFieldForId(id);
			if(field != null){
				if(object.canSet(id, value, sender)){
					try{
						object.anteSet(id, value);
						field.set(object, value);
						object.postSet(id, value);
					}catch(Exception e){
						e.printStackTrace();
					}
				}
			}
		}
	}
	
	
	public void checkValue(int subId) {
		int[] ids = classData.getIdsForCallId(subId);
		if(ids == null)return;
		
		for(int a = 0; a < ids.length; a++){
			int id = ids[a];
			Field field = classData.getFieldForId(id);
			Object value = getFieldValue(field);
			
			Object previousValue = idToValue.get(id);
			
			if(!(value == null && previousValue == null) && (value==null?!previousValue.equals(value):!value.equals(previousValue))){
				toSync.add(id);
			}
			
			idToValue.put(id, value);
		}
		sync();
	}
	
	
	public SyncData[] getForcedSyncDataForIds(int[] ids) {
		HashMap<Integer, SyncData> data = new HashMap<Integer, SyncData>();
		
		for(int a = 0; a < ids.length; a++){
			int id = ids[a];
			Object value = getCurrentValue(id);
			int channel = classData.getIdChannel(id);
			if(!data.containsKey(channel)){
				data.put(channel, new SyncData(channel));
			}
			data.get(channel).addData(id, value);
		}
		
		SyncData[] syncDatas = new SyncData[data.size()];
		Iterator<Entry<Integer, SyncData>> dataIt = data.entrySet().iterator();
		int index = 0;
		while(dataIt.hasNext()){
			syncDatas[index++] = dataIt.next().getValue();
		}
		return syncDatas;
	}
	
	static HashMap<Class, ClassData> classToData = new HashMap<Class, ClassData>();
	
	public static ClassData initClass(Class theClass){
		ClassData ret = null;
		if(!classToData.containsKey(theClass)){
			classToData.put(theClass, ret = new ClassData(theClass));
		}else{
			ret = classToData.get(theClass);
		}
		return ret;
	}

	



}
